package com.geoway.sso.client.client;

import com.geoway.sso.client.client.impl.Client;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.Oauth2Utils;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * 封装登入接口
 */

public interface SsoClient {
    /**
     * 账号密码登入
     *
     * @param username
     * @param password
     * @return
     */
     RpcAccessToken getAccessToken(String username, String password);
    /**
     * 账号密码登入
     *
     * @param username
     * @param password
     * @return
     */
    RpcAccessToken getAccessToken(String username, String password,String uuid, String code);
    /**
     * 授权码登入
     *
     * @param code
     * @return
     */
    RpcAccessToken getAccessToken(String code);
    /**
     * 短信验证码登入
     * @param tel
     * @param uuid
     * @param code
     * @return
     */
    RpcAccessToken getAccessTokenBySms(String tel, String uuid, String code);
    /**
     * 手机一键登入
     * @param processId
     * @param token
     * @param authCode
     * @return
     */
    RpcAccessToken getAccessTokenByOne(String processId, String token, String authCode);
    /**
     * Ca证书登入
     * @param caUserCert
     * @param caOauthName
     * @return
     */
    RpcAccessToken getAccessTokenByCa(String caUserCert, String caOauthName);
    /**
     * 刷新访问令牌
     *
     * @param refreshToken 刷新新令牌
     * @return
     */
    RpcAccessToken refreshToken(String refreshToken);
    /**
     * 查询令牌对应的用户登录信息
     *
     * @param accessToken 当前用户访问令牌
     * @return
     */
    RpcAccessToken queryAccessToken(String accessToken);
    /**
     * 撤销访问凭证(单点退出)
     *
     * @param accessToken 当前用户令牌
     * @return
     */
    RpcAccessToken revokeAccessToken(String accessToken);
    /**
     * 获取当前用户信息
     * @return
     */
    SsoUser getUserInfo();

    /**
     * 获取code码
     * @return
     */
    String getAccessCode(String accessToken);



}
