package com.geoway.sso.client.constant;

/**
 * @author ALMJ
 * @desc 单点登录相关常量
 */
public class SsoConstant {

    /**
     * 服务端登录地址
     */
    public static final String LOGIN_URL = "/login";

    /**
     * 服务端登出地址
     */
    public static final String LOGOUT_URL = "/logout";

    /**
     * 单点服务端退出接口
     */
    public static final String REST_LOGOUT_URL ="/logout/restLogout";

    /**
     * 服务端回调客户端地址参数名称
     */
    public static final String REDIRECT_URI = "redirectUri";

    /**
     * 前后端分离情况下登陆完后前端跳转地址
     */
    public static final String CLIENT_INDEX_URL = "indexUrl";

    /**
     * 服务端单点登出回调客户端登出参数名称
     */
    public static final String LOGOUT_PARAMETER_NAME = "logoutRequest";

    /**
     * 本地session中的AccessToken信息
     */
    public static final String SESSION_ACCESS_TOKEN = "_sessionAccessToken";
    /**
     * 本地session中的AccessToken信息
     */
    public static final String SESSION_ACCESS_USERID = "_sessionAccessUserId";
    /**
     * cookie中 AccessToken 信息
     */
    public static final String COOKIE_ACCESS_TOKEN="ns-design-token";

    /**
     * 请求头部accessToken参数信息
     */
    public static final String HEADER_ACCESS_TOKEN = "access_token";

    /**
     * 请求参数中的token
     */
    public static final String PARAM_TOKEN = "token";

    /**
     * 请求参数中的token
     */
    public static final String PARAM_TOKEN_2 = "access_token";

    public static final String PARAM_TENANT_KEY = "tenantKey";

    public static final String HEADER_ACCESS_TENANT_KEY = "tenantKey";
    public static final String HEADER_ACCESS_TENANT_ID = "tenantId";

    /**
     * 模糊匹配后缀
     */
    public static final String URL_FUZZY_MATCH = "/*";

    /**
     * 未登录或已过期
     */
    public static final int NO_LOGIN = 2100;

    /**
     * 未登录
     */
    public static final String RESPONSE_STATUS_LOGINOUT = "NEEDLOGIN";

    /**
     * 请求参数中的用户体系
     */
    public static final String PARAM_USER_SYS= "userSys";


    public static final String PARAM_USER_ID= "userId";

    /**
     * 请求头部用户体系参数信息
     */
    public static final String HEADER_USER_SYS = "access_user_sys";

    /**
     * cookie中 用户体系 信息
     */
    public static final String COOKIE_USER_SYS="ns-design-userSys";

}
