package com.geoway.sso.client.util;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.sso.client.constant.OplogConstant;
import com.geoway.sso.client.constant.RegisterConstant;
import com.geoway.sso.client.rpc.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 连世忠
 * @ClassName RegisterUtils
 * @Description 用户注册帮助类
 * @date 2025/7/21 10:44
 * @Version 1.0
 */
public class RegisterUtils {
    public static Result<Boolean> checkAccoutRepeat(String serverUrl,String account, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("accout",account);
        Result<Boolean> result= HttpUtils.postHttp(serverUrl+ RegisterConstant.CHECK_ACCOUNT_REPEAT_URL,paramMap,headerMap,null,Boolean.class);
        return result;
    }

    public static Result<Boolean> checkTelRepeat(String serverUrl,String tel, Map<String, String> headerMap) {
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("tel",tel);
        Result<Boolean> result= HttpUtils.postHttp(serverUrl+ RegisterConstant.CHECK_TEL_REPEAT_URL,paramMap,headerMap,null,Boolean.class);
        return result;
    }
    public static Result<Void> registerUser(String serverUrl,RpcSysUserRegister user, Map<String, String> headerMap) {

        Map<String, String> paramMap=new HashMap<>();
        JSONObject jsonObject= JSONUtil.parseObj(user);
        jsonObject.forEach(f->{
            if(f.getValue()!=null) {
                paramMap.put(f.getKey(),f.getValue().toString());
            }
        });
        Result<Void> result= HttpUtils.postHttp(serverUrl+ RegisterConstant.REGISTER_USER_URL,paramMap,headerMap,null,Void.class);
        return result;
    }

    public static Result<List<RpcSysOrganization>> getOrgTree(String serverUrl,String filterParam, Map<String, String> headerMap) {
        Map<String, String> paramMap=new HashMap<>();
        paramMap.put("filterParam",filterParam);
        Result<List<RpcSysOrganization>> result= HttpUtils.getHttpList(serverUrl+ RegisterConstant.QUERY_ORGTREE_URL,paramMap,headerMap,RpcSysOrganization.class);
        return result;
    }

    public static Result<List<RpcSysRegion>> getRegionTree(String serverUrl,String filterParam, Map<String, String> headerMap) {
        Map<String, String> paramMap=new HashMap<>();
        paramMap.put("filterParam",filterParam);
        Result<List<RpcSysRegion>> result= HttpUtils.getHttpList(serverUrl+ RegisterConstant.QUERY_REGIONTREE_URL,paramMap,headerMap,RpcSysRegion.class);
        return result;
    }


}
