/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.sso.client.enums.GrantTypeEnum;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.service.IOauth2Utils;
import com.geoway.sso.client.util.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="#{!T(com.geoway.sso.client.constant.SystemConstant).IS_SERVER}")
public class ClientOauth2UtilsImpl
implements IOauth2Utils {
    private static final Logger logger = LoggerFactory.getLogger(ClientOauth2UtilsImpl.class);

    @Override
    public Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grantType", GrantTypeEnum.PASSWORD.getValue());
        paramMap.put("appId", appId);
        paramMap.put("appSecret", appSecret);
        paramMap.put("username", username);
        paramMap.put("password", password);
        return ClientOauth2UtilsImpl.getHttpAccessToken(serverUrl + "/oauth2/access_token", paramMap);
    }

    @Override
    public Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password, String uuid, String code) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grantType", GrantTypeEnum.PASSWORD_CAPTCHA.getValue());
        paramMap.put("appId", appId);
        paramMap.put("appSecret", appSecret);
        paramMap.put("username", username);
        paramMap.put("password", password);
        paramMap.put("sessionId", uuid);
        paramMap.put("catpcha", code);
        return ClientOauth2UtilsImpl.getHttpAccessToken(serverUrl + "/oauth2/access_token", paramMap);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenBySms(String serverUrl, String appId, String appSecret, String tel, String uuid, String code) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grantType", GrantTypeEnum.TEL_CAPTCHA.getValue());
        paramMap.put("appId", appId);
        paramMap.put("appSecret", appSecret);
        paramMap.put("tel", tel);
        paramMap.put("sessionId", uuid);
        paramMap.put("catpcha", code);
        return ClientOauth2UtilsImpl.getHttpAccessToken(serverUrl + "/oauth2/access_token", paramMap);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenByOne(String serverUrl, String appId, String appSecret, String processId, String token, String authCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grantType", GrantTypeEnum.ONE.getValue());
        paramMap.put("appId", appId);
        paramMap.put("appSecret", appSecret);
        paramMap.put("oneAuthCode", authCode);
        paramMap.put("oneProcessId", processId);
        paramMap.put("oneToken", token);
        return ClientOauth2UtilsImpl.getHttpAccessToken(serverUrl + "/oauth2/access_token", paramMap);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenByCa(String serverUrl, String appId, String appSecret, String caUserCert, String caOauthName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grantType", GrantTypeEnum.CA.getValue());
        paramMap.put("appId", appId);
        paramMap.put("appSecret", appSecret);
        paramMap.put("caUserCert", caUserCert);
        paramMap.put("caOauthName", caOauthName);
        return ClientOauth2UtilsImpl.getHttpAccessToken(serverUrl + "/oauth2/access_token", paramMap);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenByCode(String serverUrl, String appId, String appSecret, String code) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grantType", GrantTypeEnum.AUTHORIZATION_CODE.getValue());
        paramMap.put("appId", appId);
        paramMap.put("appSecret", appSecret);
        paramMap.put("code", code);
        return ClientOauth2UtilsImpl.getHttpAccessToken(serverUrl + "/oauth2/access_token", paramMap);
    }

    @Override
    public Result<RpcAccessToken> refreshToken(String serverUrl, String appId, String refreshToken) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appId", appId);
        paramMap.put("refreshToken", refreshToken);
        return ClientOauth2UtilsImpl.getHttpAccessToken(serverUrl + "/oauth2/refresh_token", paramMap);
    }

    @Override
    public Result<RpcAccessToken> queryAccessToken(String serverUrl, String accessToken) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("access_token", accessToken);
        return ClientOauth2UtilsImpl.getHttpAccessToken(serverUrl + "/oauth2/query_access_token", paramMap);
    }

    @Override
    public Result<RpcAccessToken> revokeAccessToken(String serverUrl, String accessToken) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("access_token", accessToken);
        return ClientOauth2UtilsImpl.getHttpAccessToken(serverUrl + "/oauth2/revoke_access_token", paramMap);
    }

    @Override
    public Result<String> getAccessCode(String serverUrl, String appId, String appSecret, String accessToken) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("access_token", accessToken);
        paramMap.put("appId", appId);
        paramMap.put("appSecret", appSecret);
        return HttpUtils.getHttp(serverUrl + "/oauth2/access_code", paramMap, null, String.class);
    }

    public static Result<RpcAccessToken> getHttpAccessToken(String url, Map<String, String> paramMap) {
        String jsonStr = HttpUtils.get(url, paramMap);
        if (jsonStr == null || jsonStr.isEmpty()) {
            logger.error("getHttpAccessToken exception, return null. url:{}", (Object)url);
            return null;
        }
        return (Result)JSONObject.parseObject((String)jsonStr, (TypeReference)new TypeReference<Result<RpcAccessToken>>(){}, (Feature[])new Feature[0]);
    }
}

