/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.service.IOauth2Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Oauth2Utils {
    public static IOauth2Utils Util;

    @Autowired
    public Oauth2Utils(IOauth2Utils iOauth2Utils) {
        Util = iOauth2Utils;
    }

    public static Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password) {
        return Util.getAccessToken(serverUrl, appId, appSecret, username, password);
    }

    public static Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String code) {
        return Util.getAccessTokenByCode(serverUrl, appId, appSecret, code);
    }

    public static Result<RpcAccessToken> getAccessTokenBySms(String serverUrl, String appId, String appSecret, String tel, String uuid, String code) {
        return Util.getAccessTokenBySms(serverUrl, appId, appSecret, tel, uuid, code);
    }

    public static Result<RpcAccessToken> getAccessTokenByOne(String serverUrl, String appId, String appSecret, String processId, String token, String authCode) {
        return Util.getAccessTokenByOne(serverUrl, appId, appSecret, processId, token, authCode);
    }

    public static Result<RpcAccessToken> getAccessTokenByCa(String serverUrl, String appId, String appSecret, String caUserCert, String caOauthName) {
        return Util.getAccessTokenByCa(serverUrl, appId, appSecret, caUserCert, caOauthName);
    }

    public static Result<RpcAccessToken> refreshToken(String serverUrl, String appId, String refreshToken) {
        return Util.refreshToken(serverUrl, appId, refreshToken);
    }

    public static Result<RpcAccessToken> queryAccessToken(String serverUrl, String accessToken) {
        return Util.queryAccessToken(serverUrl, accessToken);
    }

    public static Result<RpcAccessToken> revokeAccessToken(String serverUrl, String accessToken) {
        return Util.revokeAccessToken(serverUrl, accessToken);
    }

    public static Result<String> getAccessCode(String serverUrl, String appId, String appSecret, String accessToken) {
        return Util.getAccessCode(serverUrl, appId, appSecret, accessToken);
    }
}

