package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.LoginClient;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcImgCaptchaDTO;
import com.geoway.sso.client.rpc.RpcSmsCaptchaDTO;
import com.geoway.sso.client.rpc.RpcSysOrganization;
import com.geoway.sso.client.util.LoginUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName LoginClientImpl
 * @Description TODO
 * @date 2025/6/18 10:29
 * @Version 1.0
 */
@Service
public class LoginClientImpl extends Client implements LoginClient {
    @Override
    public RpcSmsCaptchaDTO getSmsCode(String phoneNumber) {
        Result<RpcSmsCaptchaDTO> result= LoginUtils.getSmsCaptcha(provider.getRpcClientInfo().getServerUrl(),phoneNumber);
        if(result==null){
            return null;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public RpcImgCaptchaDTO getImgCaptcha() {
        Result<RpcImgCaptchaDTO> result= LoginUtils.getImgCaptcha(provider.getRpcClientInfo().getServerUrl());
        if(result==null){
            return null;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public Boolean loginOut() {
        Result<Boolean> result= LoginUtils.loginOut(provider.getRpcClientInfo().getServerUrl());
        if(result==null){
            return false;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }
}
