package com.geoway.sso.client.client.impl;


import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.rpc.RpcUserOnlineStatDTO;
import com.geoway.sso.client.rpc.RpcUserSystem;
import com.geoway.sso.client.util.UisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName UISClient
 * @Description 用户查询Client
 * @date 2025/3/24 15:42
 * @Version 1.0
 */
@Component
public class UserClientImpl extends Client implements UserClient {

    @Autowired
    private RpcClientInfoProvider provider;

    /**
     * 获取用户信息
     * @param userId
     * @return
     * @throws Exception
     */
    @Override
    public RpcSysUser getUserInfo(String userId)  {
        Result<RpcSysUser> result= UisUtils.getUserInfo(provider.getRpcClientInfo().getServerUrl(),userId,getHeader());
        if(result==null){
            return null;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }
    /**
     * 获取用户信息
     * @return
     * @throws Exception
     */
    @Override
    public RpcSysUser getCurrentUserInfo()  {
        Result<RpcSysUser> result= UisUtils.getCurrentUserInfo(provider.getRpcClientInfo().getServerUrl(),getHeader());
        if(result==null){
            return null;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     *修改用户基本信息
     * @param rpcSysUser
     * @return
     */
    @Override
    public boolean modifyCurrentUserInfo(RpcSysUser rpcSysUser) {
        if(rpcSysUser!=null){
            rpcSysUser.setOrganizations(null);
            rpcSysUser.setOrgNames(null);
            rpcSysUser.setRegions(null);
            rpcSysUser.setRoles(null);
            rpcSysUser.setRoleNames(null);
        }
        Result<Void> result= UisUtils.modifyCurrentUserInfo(provider.getRpcClientInfo().getServerUrl(),rpcSysUser,getHeader());
        if(result==null){
            return false;
        }
        if(result.isSuccess()){
            return true;
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public boolean modifyCurrentUserPassword(String oldPwd, String newPwd) {
        Result<Void> result= UisUtils.modifyCurrentUserPassword(provider.getRpcClientInfo().getServerUrl(),oldPwd,newPwd,getHeader());
        if(result==null){
            return false;
        }
        if(result.isSuccess()){
            return true;
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     * 获取用户列表
     * @param filterParam
     * @return
     */
    @Override
    public List<RpcSysUser> getUserList(String filterParam) {
        Result<List<RpcSysUser>> result= UisUtils.getUserList(provider.getRpcClientInfo().getServerUrl(),filterParam,"",getHeader());
        if(result==null){
            return new ArrayList<>();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public RpcUserOnlineStatDTO getUserOnlineStatInfo() {
        Result<RpcUserOnlineStatDTO> result= UisUtils.getUserOnlineStatInfo(provider.getRpcClientInfo().getServerUrl(),getHeader());
        if(result==null){
            return null;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public Boolean validSecure() {
        Result<Boolean> result= UisUtils.validSecure(provider.getRpcClientInfo().getServerUrl(),getHeader());
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public List<RpcUserSystem> getUserSystems() {
        Result<List<RpcUserSystem>> result= UisUtils.getUserSystems(provider.getRpcClientInfo().getServerUrl(),getHeader());
        if(result==null){
            return new ArrayList<>();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public String getCurrentUserRealTel() {
        Result<String> result= UisUtils.getCurrentUserRealTel(provider.getRpcClientInfo().getServerUrl(),getHeader());
        if(result==null){
            return "";
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

}
