package com.geoway.sso.client.constant;

/**
 * @author ALMJ
 * @desc Oauth2 规范API相关常量
 */
public class Oauth2Constant {

    /**
     * 用于保持请求和回调的状态，授权请求后原样带回给第三方。该参数可用于防止 csrf 攻击
     */
    public static final String STATE = "state";

    /**
     * 授权方式
     */
    public static final String GRANT_TYPE = "grantType";

    /**
     * 当前token
     */
    public static final String TOKEN = "access_token";

    /**
     * 第三方应用唯一标识
     */
    public static final String APP_ID = "appId";

    /**
     * 第三方应用密钥
     */
    public static final String APP_SECRET = "appSecret";

    /**
     * 刷新token
     */
    public static final String REFRESH_TOKEN = "refreshToken";

    /**
     * 授权码（授权码模式）
     */
    public static final String AUTH_CODE = "code";

    /**
     * 用户名（密码模式）
     */
    public static final String USERNAME = "username";

    /**
     * 密码（密码模式）
     */
    public static final String PASSWORD = "password";

    /**
     * 电话
     */
    public static final String TEL = "tel";
    /**
     * 会话id
     */
    public static final String SESSIONID = "sessionId";
    /**
     * 验证码
     */
    public static final String CATPCHA = "catpcha";
    /**
     * CA证书
     */
    public static final String CAUSERCERT= "caUserCert";
    /**
     * CA证书名称
     */
    public static final String CAOAUTHNAME= "caOauthName";
    /**
     * 一键登入进程id
     */
    public static final String ONEPROCESSID= "oneProcessId";
    /**
     * 一键登入Token
     */
    public static final String ONETOKEN= "oneToken";
    /**
     * 一键登入authcode
     */
    public static final String ONEAUTHCODE= "oneAuthCode";

    /**
     * 密码加密方式（md5,aes,real）
     */
    public static final String PASSWORD_TYPE   = "password_type";

    /**
     * 获取accessToken地址
     */
    public static final String ACCESS_TOKEN_URL = "/oauth2/access_token";

    /**
     * 刷新accessToken地址
     */
    public static final String REFRESH_TOKEN_URL = "/oauth2/refresh_token";

    /**
     * 查询accessToken内容
     */
    public static final String QUERY_TOKEN_CONTENT = "/oauth2/query_access_token";

    /**
     * 基于token单点退出
     */
    public static final String REVOKE_ACCESS_TOKEN="/oauth2/revoke_access_token";
    /**
     * 基于token单点退出
     */
    public static final String QUERY_ACCESS_CODE="/oauth2/access_code";
    /**
     * 查询成功
     */
    public static final int SUCCESS_CODE = 200;
    /**
     * 未知错误
     */
    public static final int ERROR_CODE = 1000;

    /**
     * 成功
     */
    public static final String STATUS_OK = "OK";
    /**
     * 失败
     */
    public static final String STATUS_FAILURE = "FAILURE";


}
