/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.MenuClient;
import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.client.impl.Client;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysSubFunction;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.util.UisUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MenuClientImpl
extends Client
implements MenuClient {
    @Autowired
    UserClient userClient;

    @Override
    public List<RpcSysSubFunction> getSubFunctions(String menuId) {
        RpcSysUser rpcSysUser = this.userClient.getCurrentUserInfo();
        if (rpcSysUser.getRoles() == null) {
            return new ArrayList<RpcSysSubFunction>();
        }
        String roleIds = rpcSysUser.getRoles().stream().map(f -> f.getId()).collect(Collectors.joining(","));
        Result<List<RpcSysSubFunction>> result = UisUtils.querySubFunctionsByMenuId(this.provider.getRpcClientInfo().getServerUrl(), roleIds, menuId, this.getHeader());
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }
}

