/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.rpc;

import java.beans.Transient;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1956544564021082972L;
    public static final int NO_LOGIN = 2100;
    public static final int STATUS_RESETPASSWORD = 3003;
    public static final Result SUCCESS = Result.createSuccess();
    protected T data;
    protected int code;
    protected String status;
    protected String message;

    private Result() {
    }

    public static <T> Result<T> create() {
        return new Result<T>();
    }

    public static <T> Result<T> create(int code) {
        Result<T> r = Result.create();
        r.setStatus("OK");
        if (code == 2100) {
            r.setStatus("FAILURE");
        }
        r.setCode(code);
        return r;
    }

    public static <T> Result<T> create(int code, String message) {
        Result<T> r = Result.create(code);
        r.setStatus("OK");
        if (code == 2100) {
            r.setStatus("FAILURE");
        }
        r.setMessage(message);
        return r;
    }

    public static <T> Result<T> createLoginRedirect(T data) {
        Result<T> r = Result.create(2100);
        r.setStatus("OK");
        r.setData(data);
        return r;
    }

    public static <T> Result<T> createNoLogin() {
        Result<T> r = Result.create(2100);
        return r;
    }

    public static <T> Result<T> createLoginRedirect(T data, String message) {
        Result<T> r = Result.create(2100);
        r.setStatus("OK");
        r.setData(data);
        r.setMessage(message);
        return r;
    }

    public static final <T> Result<T> success() {
        return SUCCESS;
    }

    public static <T> Result<T> createSuccess() {
        return Result.create(200);
    }

    public static <T> Result<T> createSuccess(T data) {
        Result<T> r = Result.createSuccess();
        r.setData(data);
        return r;
    }

    public static <T> Result<T> createError(T data) {
        Result<T> r = Result.create(1000);
        r.setStatus("FAILURE");
        r.setData(data);
        return r;
    }

    public static <T> Result<T> createSuccess(T data, String message) {
        Result<T> r = Result.createSuccess(data);
        r.setMessage(message);
        return r;
    }

    public static <T> Result<T> createError(String message) {
        Result<T> r = Result.create(1000, message);
        r.setStatus("FAILURE");
        return r;
    }

    public static <T> Result<T> createError(T data, String message) {
        Result<T> r = Result.createError(data);
        r.setMessage(message);
        return r;
    }

    public T getData() {
        return this.data;
    }

    public Result<T> setData(T data) {
        this.data = data;
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public Result<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Result<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Transient
    public boolean isSuccess() {
        return 200 == this.code || 200 == this.code || this.status.equalsIgnoreCase("OK");
    }
}

