package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.RegisterClient;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysOrganization;
import com.geoway.sso.client.rpc.RpcSysRegion;
import com.geoway.sso.client.rpc.RpcSysUserRegister;
import com.geoway.sso.client.util.RegisterUtils;
import com.geoway.sso.client.util.UisUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName RegisterClientImpl
 * @Description TODO
 * @date 2025/7/21 10:39
 * @Version 1.0
 */
@Component
public class RegisterClientImpl extends  Client implements RegisterClient {
    @Override
    public Boolean checkAccoutRepeat(String accout) {
        Result<Boolean> result= RegisterUtils.checkAccoutRepeat(provider.getRpcClientInfo().getServerUrl(),accout,getHeader());
        if(result==null){
            return false;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public Boolean checkTelRepeat(String tel) {
        Result<Boolean> result= RegisterUtils.checkTelRepeat(provider.getRpcClientInfo().getServerUrl(),tel,getHeader());
        if(result==null){
            return false;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public void registerUser(RpcSysUserRegister register) {
        RegisterUtils.registerUser(provider.getRpcClientInfo().getServerUrl(),register,getHeader());
    }

    @Override
    public List<RpcSysOrganization> getOrgTree(String filterParam) {
        Result<List<RpcSysOrganization>> result= RegisterUtils.getOrgTree(provider.getRpcClientInfo().getServerUrl(),filterParam,getHeader());
        if(result==null){
            return new ArrayList<>();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public List<RpcSysRegion> getRegionTree(String filterParam) {
        Result<List<RpcSysRegion>> result= RegisterUtils.getRegionTree(provider.getRpcClientInfo().getServerUrl(),filterParam,getHeader());
        if(result==null){
            return new ArrayList<>();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }
}
