package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.SystemClient;
import com.geoway.sso.client.client.TenantClient;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.rpc.RpcSystemInfoDTO;
import com.geoway.sso.client.util.UisUtils;
import org.springframework.stereotype.Component;

/**
 * @author 连世忠
 * @ClassName SystemClientImpl
 * @Description TODO
 * @date 2025/7/16 8:55
 * @Version 1.0
 */
@Component
public class SystemClientImpl extends Client implements SystemClient {
    @Override
    public RpcSystemInfoDTO querySystemInfoByKey(String systemKey) {
        Result<RpcSystemInfoDTO> result= UisUtils.querySystemInfoByKey(provider.getRpcClientInfo().getServerUrl(),systemKey,getHeader());
        if(result==null){
            return null;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }
}
