package com.geoway.sso.client.config;
import com.geoway.sso.client.NsSsoContainer;
import com.geoway.sso.client.filter.AppLoginFilter;
import com.geoway.sso.client.filter.AppLogoutFilter;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * @author ALMJ
 * @desc 单点登录拦截器配置容器
 */
@Configuration
@ConditionalOnProperty(value = "sso.enable", havingValue = "true")
public class NsSsoConfig {


    @Autowired
    private PermitResource permitResource;
    @Autowired
    private RpcClientInfoProvider rpcClientInfoProvider;
    @Bean
    public FilterRegistrationBean<NsSsoContainer> ssoContainer() {
        NsSsoContainer ssoContainer = new NsSsoContainer();
        ssoContainer.setServerUrl(rpcClientInfoProvider.getRpcClientInfo().getServerUrl());
        ssoContainer.setAppId(rpcClientInfoProvider.getRpcClientInfo().getAppId());
        ssoContainer.setAppSecret(rpcClientInfoProvider.getRpcClientInfo().getAppSecret());
        //有限读取auth.yml 中配置的拦截配置
        List<String> excludeUrls = permitResource.getPermitList();
        String urls = String.join(",", excludeUrls);
        // 忽略拦截URL,多个逗号分隔
        ssoContainer.setExcludeUrls(urls);
        //自定义登录界面时启用r前后端分离的拦截过滤器
        ssoContainer.setFilters(new AppLogoutFilter(), new AppLoginFilter());
        FilterRegistrationBean<NsSsoContainer> registration = new FilterRegistrationBean<>();
        registration.setFilter(ssoContainer);
        registration.addUrlPatterns("/*");
        registration.setOrder(1);
        registration.setName("ssoContainer");
        return registration;
    }

}
