/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.filter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.sso.client.filter.ClientFilter;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.util.Oauth2Utils;
import com.geoway.sso.client.util.SessionUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class LoginFilter
extends ClientFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean isAccessAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    protected void getAccessToken(String code, HttpServletRequest request) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessToken(this.getServerUrl(), this.getAppId(), this.getAppSecret(), code);
        if (!result.isSuccess()) {
            this.logger.error("getAccessToken has error, message:{}", (Object)result.getMessage());
            return;
        }
        this.setAccessTokenInSession(result.getData(), request);
    }

    protected Result<RpcAccessToken> queryAccessToken(String accessToken, HttpServletRequest request) {
        Result<RpcAccessToken> result = Oauth2Utils.queryAccessToken(this.getServerUrl(), accessToken);
        return result;
    }

    protected boolean refreshToken(String refreshToken, HttpServletRequest request) {
        try {
            Result<RpcAccessToken> result = Oauth2Utils.refreshToken(this.getServerUrl(), this.getAppId(), refreshToken);
            if (!result.isSuccess()) {
                this.logger.error("refreshToken has error, message:{}", (Object)result.getMessage());
                return false;
            }
            return this.setAccessTokenInSession(result.getData(), request);
        }
        catch (Exception e) {
            this.logger.error("refreshToken has error:" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected boolean setAccessTokenInSession(RpcAccessToken rpcAccessToken, HttpServletRequest request) {
        if (rpcAccessToken == null) {
            return false;
        }
        SessionUtils.setAccessToken(request, rpcAccessToken);
        return true;
    }

    public void redirectLocalRemoveCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String currentUrl = this.getCurrentUrl(request);
        currentUrl = currentUrl.substring(0, currentUrl.indexOf("code") - 1);
        response.sendRedirect(currentUrl);
    }

    private String getCurrentUrl(HttpServletRequest request) {
        return request.getRequestURL() + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
    }

    protected boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("X-Requested-With");
        return requestedWith != null ? "XMLHttpRequest".equals(requestedWith) : false;
    }

    protected void responseJson(HttpServletResponse response, int code, String message) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(200);
        response.getOutputStream().write(JSON.toJSONString(Result.create(code, message)).getBytes());
    }

    protected void responseJson(HttpServletResponse response, Result result) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(200);
        response.getOutputStream().write(JSON.toJSONString((Object)result).getBytes());
    }

    protected void markLoginResponse(HttpServletResponse response, String msg) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        JSONObject baseResopnse = new JSONObject();
        baseResopnse.put("code", (Object)2100);
        baseResopnse.put("status", (Object)"NEEDLOGIN");
        baseResopnse.put("message", (Object)"\u65e0\u6548token\u6216token\u5df2\u8fc7\u671f");
        if (StrUtil.isNotEmpty((CharSequence)msg)) {
            baseResopnse.put("message", (Object)msg);
        }
        String jsonResult = JSON.toJSONString((Object)baseResopnse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
        response.getOutputStream().write(jsonResult.getBytes());
    }
}

