/**
 *
 */
package com.geoway.sso.client.annotation;

import com.geoway.sso.client.enums.OpTypeEnum;

import java.lang.annotation.*;

/**
 * 日志拦截AOP
 * @author daidd
 *
 */
@Target({ElementType.PARAMETER, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface OpLog {
    /**
     * 模块名称
     */
    String name() default "";

    /**
     * 日志内容
     */
    String detail() default "";

    /**
     * 操作类别
     */
    OpTypeEnum opType() default OpTypeEnum.search;
}
