package com.geoway.sso.client.client;

import com.geoway.sso.client.client.impl.Client;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysOrganization;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.util.UisUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName OrgClient
 * @Description TODO
 * @date 2025/3/26 11:31
 * @Version 1.0
 */

public interface OrganizationClient  {
    /**
     * 获取完整的机构树
     * @param
     * @return
     */
     List<RpcSysOrganization> getOrgTree();
    /**
     * 查询这个机构的下一级子机构（只查下一级）,不返回本身
     * @param
     * @return
     */
     List<RpcSysOrganization> getChildOrg(String id);

    /**
     * 获取组织机构详情，返回本身+下一级子机构(只查下一级)
     * @param id
     * @param filterParam
     * @return
     */
     RpcSysOrganization  getOrgInfo(String id,String filterParam);

    /**
     * 获取组织机构下的用户，只查本级
     * @param id
     * @return
     */
     List<RpcSysUser>  getRelUsers(String id);
}
