package com.geoway.sso.client.enums;

public enum RoleLevelEnum {
    /**
     * 超级管理员
     */
     superAdmin(1,10),
    /**
     * 租户管理员
     */
     tenantAdmin(11,11),
     /**
     * 业务管理员
     */
     bizAdmin(2,20),
    /**
     * 普通用户
     */
     commonUser(3,30),
    /**
     * 游客
     */
     guest(4,40),
    /**
     *
     */
     None(99,99);
     private final Integer value;
     private final Integer level;
     RoleLevelEnum(int value,int level){
         this.level=level;
         this.value = value;
     }
     public int getValue(){
        return  this.value;
     }
    public int getLevel(){
        return  this.level;
    }
    public static RoleLevelEnum getEnumByValue(int value) {
        for (RoleLevelEnum roleLevelEnum : RoleLevelEnum.values()) {
            if (roleLevelEnum.value == value) {
                return roleLevelEnum;
            }
        }
        return None;
    }
}
