package com.geoway.sso.client.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.filter.ParamFilter;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * 获取当前登录用户的相关方法
 *
 * @author ALMJ
 * @date 2022/6/24 11:47
 */
@Component
public class CommonLoginUserUtil extends ParamFilter {
    private static String serverUrl;
    @Value("${sso.server.url:}")
    public void setAddress(String url) {
        this.serverUrl = url;
    }

    /**
     * 获取当前登录用户Token
     *
     * @return
     */
    public static String getToken() {
        // 获取当前http请求
        HttpServletRequest request = HttpServletUtil.getRequest();
        if(request==null){
            return "";
        }
        // 1. 优先从param参数中获取token
        String parameterToken = request.getParameter(SsoConstant.PARAM_TOKEN);
        // 不为空则直接返回param的token
        if (StrUtil.isNotBlank(parameterToken)) {
            return parameterToken;
        }
        parameterToken = request.getParameter(SsoConstant.PARAM_TOKEN_2);
        // 不为空则直接返回param的token
        if (StrUtil.isNotBlank(parameterToken)) {
            return parameterToken;
        }
        // 2. 从header中获取token
        String authToken = request.getHeader(SsoConstant.HEADER_ACCESS_TOKEN);
        if (StrUtil.isNotBlank(authToken)) {
            return authToken;
        }

        // 3. 从cookie中获取token
        String sessionCookieName = CookieUtils.getCookie(request, SsoConstant.COOKIE_ACCESS_TOKEN);
        if (StrUtil.isNotBlank(sessionCookieName)) {
            return sessionCookieName;
        }
        return null;
    }
    public static String getTenantKey() {
        // 获取当前http请求
        HttpServletRequest request = HttpServletUtil.getRequest();
        if(request==null){
            return "";
        }
        // 2. 从header中获取token
        String headerKey = request.getHeader(SsoConstant.HEADER_ACCESS_TENANT_KEY);
        if (StrUtil.isNotBlank(headerKey)) {
            return headerKey;
        }
        // 1. 优先从param参数中获取token
        String parameterTenant = request.getParameter(SsoConstant.PARAM_TENANT_KEY);
        // 不为空则直接返回param的token
        if (StrUtil.isNotBlank(parameterTenant)) {
            return parameterTenant;
        }
        return null;
    }
    public static String getTenantID() {
        // 获取当前http请求
        HttpServletRequest request = HttpServletUtil.getRequest();
        if(request==null){
            return null;
        }
        // 1. 从header中获取tenantId
        String authTenant = request.getHeader(SsoConstant.HEADER_ACCESS_TENANT_ID);
        if (StrUtil.isNotBlank(authTenant)) {
            return authTenant;
        }
        return null;
    }
    /**
     * 获取当前登录的用户基本信息
     *
     * @return
     */
    public static SsoUser getUser() {
       return getUser(getToken());
    }


    /**
     * 获取当前登录的用户基本信息
     *
     * @return
     */
    public static String getQueryUserId() {
        // 获取当前http请求
        HttpServletRequest request = HttpServletUtil.getRequest();
        // 1. 优先从param参数中获取token
        String userId = request.getParameter(SsoConstant.PARAM_USER_ID);
        if(StrUtil.isNotBlank(userId)){
            return userId;
        }
        return getUserId();
    }
    /**
     * 按token 获取当前登录用户信息
     *
     * @param accessToken
     * @return 若没找到用户，或登录过期返回null
     */
    public static SsoUser getUser(String accessToken) {
        HttpServletRequest request = HttpServletUtil.getRequest();
        SsoUser user = SessionUtils.getUser(request, accessToken);
        if (ObjectUtil.isNotNull(user)) return user;
        if (!StrUtil.isAllNotEmpty(accessToken)) return null;
        Result<RpcAccessToken> result = Oauth2Utils.queryAccessToken(serverUrl, accessToken);
        if (result.isSuccess() && ObjectUtil.isNotNull(result.getData())) return result.getData().getUser();
        return null;
    }
    /**
     * 按token 获取当前登录用户的用户id
     *
     * @param accessToken
     * @return 若没找到用户，或登录过期返回null
     */
    public static String getUserId() {
        SsoUser ssoUser=getUser();
        return ssoUser!=null?ssoUser.getUserid():"";
    }
}
