package com.geoway.sso.client.util;

import com.geoway.sso.client.constant.LoginConstant;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcImgCaptchaDTO;
import com.geoway.sso.client.rpc.RpcSmsCaptchaDTO;


import java.util.HashMap;
import java.util.Map;

import static com.geoway.sso.client.util.HttpUtils.getHttp;

/**
 * @author 连世忠
 * @ClassName LoginUtils
 * @Description TODO
 * @date 2025/6/18 10:30
 * @Version 1.0
 */
public class LoginUtils {
    public static Result<RpcImgCaptchaDTO> getImgCaptcha(String serverUrl) {
        Result<RpcImgCaptchaDTO> result= getHttp(serverUrl+ LoginConstant.GET_CAPTCHAPNG_URL,null,null,RpcImgCaptchaDTO.class);
        return result;
    }
    public static Result<RpcSmsCaptchaDTO> getSmsCaptcha(String serverUrl,String phoneNumber) {
        Map<String,String> param=new HashMap<>();
        param.put("phoneNumber",phoneNumber);
        Result<RpcSmsCaptchaDTO> result= getHttp(serverUrl+ LoginConstant.GET_SMSCODE_URL,param,null,RpcSmsCaptchaDTO.class);
        return result;
    }

    public  static Result<Boolean> loginOut(String serverUrl){
        Result<Boolean> result= getHttp(serverUrl+ LoginConstant.LOGINGOUT_URL,null,null,Boolean.class);
        return result;
    }

}
