package com.geoway.sso.client.client;

import com.geoway.sso.client.client.impl.Client;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcPage;
import com.geoway.sso.client.rpc.RpcSysRole;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.util.UisUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName UserClient
 * @Description TODO
 * @date 2025/3/26 11:32
 * @Version 1.0
 */

public interface RoleClient {
    /**
     * 获取角色树列表
     * @param filterParam
     * @return
     */
     List<RpcSysRole> queryRoleTree(String filterParam);


    /**
     * 获取角色列表
     * @param filterParam
     * @return
     */
    List<RpcSysRole> queryRoleList( String filterParam);

    /**
     * 获取角色关联用户
     * @param roleId
     * @return
     */
    List<RpcSysUser> queryRoleUsers(String roleId);

    /**
     * 分页查询角色
     * @param filterParam
     * @param page
     * @param size
     * @return
     */
    RpcPage<RpcSysRole> queryRolePage(String filterParam,Integer page,Integer size);
}
