package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.OrganizationClient;
import com.geoway.sso.client.rpc.RpcSysOrganization;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.util.UisUtils;
import com.geoway.sso.client.rpc.Result;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName OrgClient
 * @Description TODO
 * @date 2025/3/26 11:31
 * @Version 1.0
 */
@Component
public class OrganizationClientImpl extends Client implements OrganizationClient {
    /**
     * 获取机构树
     * @param
     * @return
     */
    @Override
    public List<RpcSysOrganization> getOrgTree() {
        Result<List<RpcSysOrganization>> result= UisUtils.getOrgTree(provider.getRpcClientInfo().getServerUrl(),getHeader());
        if(result==null){
            return new ArrayList<>();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     * 获取机构详情

     * @param pid
     * @return
     */
    @Override
    public List<RpcSysOrganization> getChildOrg(String pid) {
        Result<List<RpcSysOrganization>> result= UisUtils.getChildOrg(provider.getRpcClientInfo().getServerUrl(),pid,getHeader());
        if(result==null){
            return new ArrayList<>();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public RpcSysOrganization getOrgInfo(String id, String filterParam) {
        Result<RpcSysOrganization> result= UisUtils.getOrgInfo(provider.getRpcClientInfo().getServerUrl(),id,filterParam,getHeader());
        if(result==null){
            return null;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public List<RpcSysUser> getRelUsers(String id) {

        Result<List<RpcSysUser>> result= UisUtils.getRelUsers(provider.getRpcClientInfo().getServerUrl(),id,getHeader());
        if(result==null){
            return null;
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }

    }
}
