/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean isAllEmpty(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String str : strings) {
            if (!StringUtils.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHasEmpty(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String str : strings) {
            if (!StringUtils.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static String isEmpty(String checkValue, String defaultValue) {
        return StringUtils.isEmpty(checkValue) ? defaultValue : checkValue;
    }

    public static boolean isNotEmptyAndEquelsOther(String str, String other) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return str.equals(other);
    }

    public static boolean isNotEmptyAndNotEquelsOther(String str, String ... other) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < other.length; ++i) {
            if (!str.equals(other[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEquelsOther(String str, String ... other) {
        for (int i = 0; i < other.length; ++i) {
            if (!other[i].equals(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String ... strings) {
        if (strings == null) {
            return false;
        }
        for (String str : strings) {
            if (str != null && !"".equals(str.trim())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String value, String equals) {
        if (StringUtils.isAllEmpty(value, equals)) {
            return true;
        }
        return value.equals(equals);
    }

    public static boolean isNotEquals(String value, String equals) {
        return !StringUtils.equals(value, equals);
    }

    public static String[] split(String content, String separatorChars) {
        return StringUtils.splitWorker(content, separatorChars, -1, false);
    }

    public static String[] split(String str, String separatorChars, int max) {
        return StringUtils.splitWorker(str, separatorChars, max, false);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(EMPTY_STRING_ARRAY);
    }

    public static String escapeXML(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '$': 
                case '\u00ff': {
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block8;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f' || c >= '\ue000' && c <= '\uf8ff' || c >= '\ufff0' && c <= '\uffff') continue block8;
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String replace(String s, Map<String, Object> map) {
        int end;
        int start;
        StringBuilder ret = new StringBuilder((int)((double)s.length() * 1.5));
        int cursor = 0;
        while ((start = s.indexOf("${", cursor)) != -1 && (end = s.indexOf("}", start)) != -1) {
            ret.append(s.substring(cursor, start)).append(map.get(s.substring(start + 2, end)));
            cursor = end + 1;
        }
        ret.append(s.substring(cursor, s.length()));
        return ret.toString();
    }

    public static String replace(String s, Object ... objs) {
        int start;
        if (objs == null || objs.length == 0) {
            return s;
        }
        if (s.indexOf("{}") == -1) {
            return s;
        }
        StringBuilder ret = new StringBuilder((int)((double)s.length() * 1.5));
        int cursor = 0;
        int index = 0;
        while ((start = s.indexOf("{}", cursor)) != -1) {
            ret.append(s.substring(cursor, start));
            if (index < objs.length) {
                ret.append(objs[index]);
            } else {
                ret.append("{}");
            }
            cursor = start + 2;
            ++index;
        }
        ret.append(s.substring(cursor, s.length()));
        return ret.toString();
    }

    public static String replaceArgs(String source, Object ... params) {
        if (params == null || params.length == 0 || source == null || source.isEmpty()) {
            return source;
        }
        StringBuilder buff = new StringBuilder(source);
        StringBuilder temp = new StringBuilder();
        int startIndex = 0;
        int endIndex = 0;
        String param = null;
        for (int count = 0; count < params.length; ++count) {
            param = params[count] == null ? null : params[count].toString();
            temp.delete(0, temp.length());
            temp.append("{");
            temp.append(count);
            temp.append("}");
            while ((startIndex = buff.indexOf(temp.toString(), endIndex)) != -1) {
                endIndex = startIndex + temp.length();
                buff.replace(startIndex, endIndex, param == null ? "" : param);
            }
            startIndex = 0;
            endIndex = 0;
        }
        return buff.toString();
    }

    public static String substringBefore(String s, String separator) {
        if (StringUtils.isEmpty(s) || separator == null) {
            return s;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = s.indexOf(separator);
        if (pos < 0) {
            return s;
        }
        return s.substring(0, pos);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String substringAfter(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] getBytes(String str) {
        if (str != null) {
            try {
                return str.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }
}

