package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.QrLoginClient;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.RpcQrLoginDTO;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.QrLoginUtils;
import org.springframework.stereotype.Component;

/**
 * @author 连世忠
 * @ClassName QrLoginClientImpl
 * @Description TODO
 * @date 2025/7/24 8:26
 * @Version 1.0
 */
@Component
public class QrLoginClientImpl extends Client implements QrLoginClient {
    @Override
    public RpcQrLoginDTO generateQrCode() {
        Result<RpcQrLoginDTO> result = QrLoginUtils.generateQrCode(provider.getRpcClientInfo().getServerUrl(), getHeader());
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public SsoUser getLoginInfo(String key) {
        Result<SsoUser> result = QrLoginUtils.getLoginInfo(provider.getRpcClientInfo().getServerUrl(), key, getHeader());
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public Boolean autoLogin(String accessToken, String key, String state) {
        Result<Void> result = QrLoginUtils.autoLogin(provider.getRpcClientInfo().getServerUrl(), accessToken, key, state, getHeader());
        return result != null && result.isSuccess();
    }

    @Override
    public String getQrStatus(String key) {
        Result<String> result = QrLoginUtils.getQrStatus(provider.getRpcClientInfo().getServerUrl(), key, getHeader());
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public RpcAccessToken refreshQrLogin(String token) {
        Result<RpcAccessToken> result = QrLoginUtils.refreshQrLogin(provider.getRpcClientInfo().getServerUrl(), token, provider.getRpcClientInfo().getAppId(), getHeader());
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }
}
