/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.client.impl.Client;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.rpc.RpcUserOnlineStatDTO;
import com.geoway.sso.client.rpc.RpcUserSystem;
import com.geoway.sso.client.util.UisUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserClientImpl
extends Client
implements UserClient {
    @Autowired
    private RpcClientInfoProvider provider;

    @Override
    public RpcSysUser getUserInfo(String userId) {
        Result<RpcSysUser> result = UisUtils.getUserInfo(this.provider.getRpcClientInfo().getServerUrl(), userId, this.getHeader());
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public RpcSysUser getCurrentUserInfo() {
        Result<RpcSysUser> result = UisUtils.getCurrentUserInfo(this.provider.getRpcClientInfo().getServerUrl(), this.getHeader());
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public boolean modifyCurrentUserInfo(RpcSysUser rpcSysUser) {
        Result<Void> result;
        if (rpcSysUser != null) {
            rpcSysUser.setOrganizations(null);
            rpcSysUser.setOrgNames(null);
            rpcSysUser.setRegions(null);
            rpcSysUser.setRoles(null);
            rpcSysUser.setRoleNames(null);
        }
        if ((result = UisUtils.modifyCurrentUserInfo(this.provider.getRpcClientInfo().getServerUrl(), rpcSysUser, this.getHeader())) == null) {
            return false;
        }
        if (result.isSuccess()) {
            return true;
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public boolean modifyCurrentUserPassword(String oldPwd, String newPwd) {
        Result<Void> result = UisUtils.modifyCurrentUserPassword(this.provider.getRpcClientInfo().getServerUrl(), oldPwd, newPwd, this.getHeader());
        if (result == null) {
            return false;
        }
        if (result.isSuccess()) {
            return true;
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public Boolean modifyPassword(String phoneNum, String verifyCode, String verifyCodeUid, String password) {
        Result<Void> result = UisUtils.modifyPassword(this.provider.getRpcClientInfo().getServerUrl(), phoneNum, verifyCode, verifyCodeUid, password, this.getHeader());
        if (result == null) {
            return false;
        }
        if (result.isSuccess()) {
            return true;
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public List<RpcSysUser> getUserList(String filterParam) {
        Result<List<RpcSysUser>> result = UisUtils.getUserList(this.provider.getRpcClientInfo().getServerUrl(), filterParam, "", this.getHeader());
        if (result == null) {
            return new ArrayList<RpcSysUser>();
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public RpcUserOnlineStatDTO getUserOnlineStatInfo() {
        Result<RpcUserOnlineStatDTO> result = UisUtils.getUserOnlineStatInfo(this.provider.getRpcClientInfo().getServerUrl(), this.getHeader());
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public Boolean validSecure() {
        Result<Boolean> result = UisUtils.validSecure(this.provider.getRpcClientInfo().getServerUrl(), this.getHeader());
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public List<RpcUserSystem> getUserSystems() {
        Result<List<RpcUserSystem>> result = UisUtils.getUserSystems(this.provider.getRpcClientInfo().getServerUrl(), this.getHeader());
        if (result == null) {
            return new ArrayList<RpcUserSystem>();
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public String getCurrentUserRealTel() {
        Result<String> result = UisUtils.getCurrentUserRealTel(this.provider.getRpcClientInfo().getServerUrl(), this.getHeader());
        if (result == null) {
            return "";
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }
}

