package com.geoway.sso.client.rpc;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @TableName sys_role
 */
@Data
public class RpcSysRole implements Comparable<RpcSysRole>, Serializable {

    /**
     *
     */

    private String id;

    /**
     *
     */
    private String name;

    /**
     *
     */
    private String key;

    /**
     *
     */
    private Integer level;

    /**
     *
     */
    private String pid;

    /**
     *
     */
    private Integer type;

    /**
     *
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     *
     */
    private String parents;


    private String allname;

    /**
     *
     */
    private String bz;

    /**
     *排序
     */
    private Integer sort;

    /**
     * 创建者id(管理员为0）
     */
    private String creatorid = "1";

    private List<RpcSysRole> children;

    @Override
    public int compareTo(RpcSysRole o) {
        Integer iResult = 0;
        if (o.level != null && this.level != null) {
            iResult = this.level.compareTo(o.level);
        }
        return iResult;
    }
}