package com.geoway.sso.client.rpc;

import lombok.Data;

import java.io.Serializable;

/**
 * @author ALMJ
 * @desc 已登录用户对象
 */
@Data
public class SsoUser implements Serializable {
    private static final long serialVersionUID = 1764365572138947234L;

    public SsoUser(){
        passwordPolicy=new PasswordPolicy();
    }
    /**
     * 用户id
     */
    private String id;

    /**
     * 登录名
     */
    private String loginName;

    /**
     * token
     */
    private String token;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 用户id
     */
    private String userid;

    /**
     * 行政区代码
     */
    private String regionCode;

    /**
     * 行政区名称
     */
    private String regionName;

    /**
     * ip
     */
    private String ip;

    /**
     * 登录时间
     */
    private String loginTime;

    /**
     * 用户分类，1系统管理员，2租户管理员，3普通用户
     */
    private Integer userCatalog;

    /**
     * 密码策略
     */
    private PasswordPolicy  passwordPolicy;

    /**
     * 租户管理员管理的租户空间
     */
    private String tenantIds;

    /**
     * 角色id
     */
    private String roldIds;
    /**
     * 请求客户端的名称
     */
    private String machineName;

    /**
     * 用户体系来源
     */
    private String source;

    /**
     * 办公地点
     */
    private String address;

}
