package com.geoway.sso.client.rpc;


import lombok.Data;
import lombok.experimental.FieldNameConstants;

import java.io.Serializable;
import java.util.List;

/**
 * 
 * @TableName sys_menu
 */

@Data
@FieldNameConstants
public class RpcSysMenu extends  RpcSaasEntity implements Serializable {
    /**
     * id
     */

    private String id;

    /**
     * 名称
     */

    private String name;

    /**
     * 菜单关键字
     */

    private String key;

    /**
     * 上级id
     */

    private String pid;

    /**
     * 路径id
     */
    private String pathId;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 对应系统id
     */
    private String systemId;

    /**
     * 菜单分组(1.普通菜单 2.个人中心菜单）
     */
    private Integer group;

    /**
     * 菜单类型（1.原始菜单 2.挂接菜单）
     */
    private Integer menuType;

    /**
     * 关联菜单id
     */
    private String relMenuId;

    /**
     * 打开方式（1.单页面 2.iframe 3.x新页面）
     */
    private Integer openMode;

    /**
     * 是否缓存
     */
    private Integer isCache;

    /**
     * 是否免登录
     */
    private Integer nologin = 0;

    /**
     * 是否免登录
     */
    private Integer isdefault = 0;


    /**
     * 菜单icon
     */
    private String icon;

    /**
     * 激活图标base64
     */
    private String activeIcon;

    /**
     * 是否资源隔离
     */
    private Integer isolate = 0;

    /**
     * 菜单路径
     */
    private String path;

    /**
     * 路径类型（1.相对路径 2.绝对路径）
     */
    private Integer pathType;





    /**
     * 菜单绝对路径
     */

    private String absPath;



    private List<RpcSysMenu> children;



}