package com.geoway.sso.client.rpc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;


@Data
public class RpcSysUserRegister implements Serializable {


    /**
     * 账户名
     */
    @ApiModelProperty(value = "账户名", required = true)
    private String name;

    /**
     * 人名
     */
    @ApiModelProperty(value = "人名")
    private String aname;


    private String password;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话", required = true)
    private String tel;
    /**
     * 邮箱
     */

    @ApiModelProperty(value = "邮箱")
    private String email;
    /**
     * 机构
     */

    @ApiModelProperty(value = "机构")
    private String organization;

    /**
     * 辖区
     */
    @ApiModelProperty(value = "辖区")
    private String region;

    /**
     * 用户类别
     */

    private Integer kind;

    @ApiModelProperty(value = "注册时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createtime;
    /**
     * 用户来源
     */
    @ApiModelProperty(value = "用户来源")
    private String source;
    /**
     * 办公地址
     */
    @ApiModelProperty(value = "办公地址")
    private String address;

    /**
     * 无需审核【用户角色会被固定为游客】
     */
    @ApiModelProperty(hidden = true)
    private Boolean noNeedAudit;

    /**
     * sms验证码标识
     */
    @ApiModelProperty(hidden = true)
    private String smsUid;

    /**
     * sms验证码标识
     */
    @ApiModelProperty(hidden = true)
    private String smsCode;
}