/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.config;

import com.geoway.sso.client.NsSsoContainer;
import com.geoway.sso.client.config.PermitResource;
import com.geoway.sso.client.filter.AppLoginFilter;
import com.geoway.sso.client.filter.AppLogoutFilter;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"sso.enable"}, havingValue="true")
public class NsSsoConfig {
    @Autowired
    private PermitResource permitResource;
    @Autowired
    private RpcClientInfoProvider rpcClientInfoProvider;

    @Bean
    public FilterRegistrationBean<NsSsoContainer> ssoContainer() {
        NsSsoContainer ssoContainer = new NsSsoContainer();
        ssoContainer.setServerUrl(this.rpcClientInfoProvider.getRpcClientInfo().getServerUrl());
        ssoContainer.setAppId(this.rpcClientInfoProvider.getRpcClientInfo().getAppId());
        ssoContainer.setAppSecret(this.rpcClientInfoProvider.getRpcClientInfo().getAppSecret());
        List<String> excludeUrls = this.permitResource.getPermitList();
        String urls = String.join((CharSequence)",", excludeUrls);
        ssoContainer.setExcludeUrls(urls);
        ssoContainer.setFilters(new AppLogoutFilter(), new AppLoginFilter());
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)ssoContainer);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(1);
        registration.setName("ssoContainer");
        return registration;
    }
}

