package com.geoway.sso.client.client;

import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysOrganization;
import com.geoway.sso.client.rpc.RpcSysRegion;
import com.geoway.sso.client.rpc.RpcSysUserRegister;

import java.util.List;

/**
 * @author 连世忠
 * @ClassName RegisterClient
 * @Description 用户注册接口
 * @date 2025/7/21 10:15
 * @Version 1.0
 */
public interface RegisterClient {
    /**
     * 检查账号是否重复
     * @param accout
     * @return
     */
   Boolean checkAccoutRepeat(String accout);

    /**
     * 检查点好号码是否重复
     * @param tel
     * @return
     */
    Boolean checkTelRepeat(String tel);

    /**
     * 注册用户
     * @param register
     */
    Result<Void> registerUser(RpcSysUserRegister register);

    /**
     * 查询组织机构树
     * @param filterParam
     * @return
     */
   List<RpcSysOrganization> getOrgTree(String filterParam);

    /**
     * 获取政区树
     * @param filterParam
     * @return
     */
   List<RpcSysRegion>  getRegionTree(String filterParam);

}
