package com.geoway.sso.client.client;


import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.rpc.RpcUserOnlineStatDTO;
import com.geoway.sso.client.rpc.RpcUserSystem;

import java.util.List;

/**
 * @author 连世忠
 * @ClassName UISClient
 * @Description 用户查询Client
 * @date 2025/3/24 15:42
 * @Version 1.0
 */
public interface UserClient {
    /**
     * 获取用户信息
     *
     * @param userId
     * @return
     * @throws Exception
     */
    RpcSysUser getUserInfo(String userId);

    /**
     * 获取当前登入的用户信息
     *
     * @return
     * @throws Exception
     */
    RpcSysUser getCurrentUserInfo();

    /**
     * 修改当前用户的基本信息
     *
     * @param rpcSysUser
     * @return
     */
    boolean modifyCurrentUserInfo(RpcSysUser rpcSysUser);

    /**
     * 修改当前用户的密码
     *
     * @param oldPwd
     * @param newPwd
     * @return
     */
    boolean modifyCurrentUserPassword(String oldPwd, String newPwd);

    /**
     * 修改密码/忘记密码
     */
    Boolean modifyPassword(String phoneNum, String verifyCode, String verifyCodeUid, String password);

    /**
     * 获取用户列表
     *
     * @param filterParam
     * @return
     */
    List<RpcSysUser> getUserList(String filterParam);

    /**
     * 在线用户统计
     *
     * @return
     */
    RpcUserOnlineStatDTO getUserOnlineStatInfo();

    /**
     * 校验当前用户是否需要重置密码
     *
     * @return
     */
    Boolean validSecure();


    List<RpcUserSystem> getUserSystems();

    /**
     * 获取当前用户的真实手机号
     *
     * @return
     */
    String getCurrentUserRealTel();
}
