package com.geoway.sso.client.client.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.geoway.sso.client.client.ImageClient;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author 连世忠
 * @ClassName ImageClientImpl
 * @Description TODO
 * @date 2025/7/22 16:46
 * @Version 1.0
 */
@Component
public class ImageClientImpl extends Client implements ImageClient {
    @Override
    public void findOneImage(HttpServletResponse response, String id) throws Exception{
        HttpRequest request = HttpUtil.createRequest(Method.GET, provider.getRpcClientInfo().getServerUrl() +"/images/"+id+".png");
        HttpResponse execute = request.execute();
        try (InputStream is = new BufferedInputStream(execute.bodyStream())){
             response.setContentType("image/png");
             OutputStream outputStream = response.getOutputStream();
             byte[] buffer = new byte[is.available()];
             is.read(buffer);
             outputStream.write(buffer);
             outputStream.flush();
             outputStream.close();
        }

    }
}
