package com.geoway.sso.client.service;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;

import javax.servlet.http.HttpServletRequest;


/**
 * @author 连世忠
 * @ClassName IOauthUtils
 * @Description TODO
 * @date 2025/5/20 15:27
 * @Version 1.0
 */
public interface IOauth2Utils {
    /**
     * 获取accessToken
     *
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param username
     * @param password
     * @return
     */
    Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password);

    /**
     * 获取accessToken
     *
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param username
     * @param password
     * @return
     */
    Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password,String uuid,String code);

    /**
     * 授权码登入
     *
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param code
     * @return
     */
    Result<RpcAccessToken> getAccessTokenByCode(String serverUrl, String appId, String appSecret, String code) ;
    /**
     * 手机验证码
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param tel
     * @param uuid
     * @param code
     * @return
     */
    Result<RpcAccessToken> getAccessTokenBySms(String serverUrl, String appId, String appSecret, String tel, String uuid, String code);
    /**
     * 手机一键登入
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param processId
     * @param token
     * @param authCode
     * @return
     */
    Result<RpcAccessToken> getAccessTokenByOne(String serverUrl, String appId, String appSecret,String processId, String token, String authCode);

    /**
     * Ca证书登入
     * @param serverUrl
     * @param appId
     * @param appSecret
     * @param caUserCert
     * @param caOauthName
     * @return
     */
    Result<RpcAccessToken> getAccessTokenByCa(String serverUrl, String appId, String appSecret,String caUserCert, String caOauthName);


    /**
     * 刷新accessToken
     *
     * @param serverUrl    单点登录服务地址
     * @param appId        应用授权id
     * @param refreshToken 刷新新令牌
     * @return
     */
     Result<RpcAccessToken> refreshToken(String serverUrl, String appId, String refreshToken);

    /**
     * 查询令牌对应的用户登录信息
     *
     * @param serverUrl   单点登录服务地址
     * @param accessToken 当前用户访问令牌
     * @return
     */
    Result<RpcAccessToken> queryAccessToken(String serverUrl, String accessToken);

    /**
     * 撤销访问凭证(单点退出)
     *
     * @param serverUrl   单点登录服务地址
     * @param accessToken 当前用户令牌
     * @return
     */
    Result<RpcAccessToken> revokeAccessToken(String serverUrl, String accessToken);

    Result<String> getAccessCode(String serverUrl, String appId, String appSecret,String accessToken,Integer allowedUseCount);
    Result<String> getAccessCode(String serverUrl, String appId, String appSecret,String accessToken);

}
