/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client;

import com.geoway.sso.client.filter.ClientFilter;
import com.geoway.sso.client.filter.ParamFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NsSsoContainer
extends ParamFilter
implements Filter {
    protected String excludeUrls;
    protected String includeUrls;
    private ClientFilter[] filters;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.filters == null || this.filters.length == 0) {
            throw new IllegalArgumentException("filters\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ClientFilter filter : this.filters) {
            filter.setAppId(this.getAppId());
            filter.setAppSecret(this.getAppSecret());
            filter.setServerUrl(this.getServerUrl());
            filter.setServerHttpsUrl(this.getServerHttpsUrl());
            filter.setLoginApi(this.getLoginApi());
            filter.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String reqUrl = httpRequest.getServletPath();
        String logoutReqHeader = httpRequest.getHeader("logoutRequest");
        if (this.isExcludeUrl(reqUrl) && logoutReqHeader == null) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        for (ClientFilter filter : this.filters) {
            if (filter.isAccessAllowed(httpRequest, httpResponse)) continue;
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isExcludeUrl(String url) {
        if (this.excludeUrls == null || this.excludeUrls.isEmpty()) {
            return false;
        }
        return this.matchUrls(this.excludeUrls, url);
    }

    private boolean isIncludeUrl(String url) {
        if (this.includeUrls == null || this.includeUrls.isEmpty()) {
            return false;
        }
        return this.matchUrls(this.includeUrls, url);
    }

    public void destroy() {
        if (this.filters == null || this.filters.length == 0) {
            return;
        }
        for (ClientFilter filter : this.filters) {
            filter.destroy();
        }
    }

    public void setExcludeUrls(String excludeUrls) {
        this.excludeUrls = excludeUrls;
    }

    public void setIncludeUrls(String includeUrls) {
        this.includeUrls = includeUrls;
    }

    public void setFilters(ClientFilter ... filters) {
        this.filters = filters;
    }

    private boolean matchUrls(String urlsString, String url) {
        Map<Boolean, List<String>> map = Arrays.stream(urlsString.split(",")).collect(Collectors.partitioningBy(u -> u.endsWith("/*")));
        List<String> urlList = map.get(false);
        for (String fullUrl : urlList) {
            if (!fullUrl.trim().equals(url)) continue;
            return true;
        }
        urlList = map.get(true);
        for (String matchUrl : urlList) {
            if (!url.startsWith(matchUrl.trim().replace("/*", ""))) continue;
            return true;
        }
        return false;
    }
}

