package com.geoway.sso.client.util;

import com.geoway.sso.client.constant.OplogConstant;
import com.geoway.sso.client.constant.QrLoginConstant;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.RpcOplog;
import com.geoway.sso.client.rpc.RpcQrLoginDTO;
import com.geoway.sso.client.rpc.SsoUser;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 连世忠
 * @ClassName QrLoginUtils
 * @Description TODO
 * @date 2025/7/24 8:30
 * @Version 1.0
 */
public class QrLoginUtils {

    public static Result<RpcQrLoginDTO> generateQrCode(String serverUrl, Map<String, String> headerMap) {
        Result<RpcQrLoginDTO> result = HttpUtils.getHttp(serverUrl + QrLoginConstant.GET_QrCode_URL, new HashMap<>(), headerMap, RpcQrLoginDTO.class);
        return result;
    }

    public static Result<SsoUser> getLoginInfo(String serverUrl, String key, Map<String, String> headerMap) {
        Map<String, String> param = new HashMap<>();
        param.put("key", key);
        Result<SsoUser> result = HttpUtils.getHttp(serverUrl + QrLoginConstant.GET_LoginInfo_URL, param, headerMap, SsoUser.class);
        return result;
    }

    public static Result<Void> autoLogin(String serverUrl, String accessToken, String key, String state, Map<String, String> headerMap) {
        Map<String, String> param = new HashMap<>();
        param.put("key", key);
        param.put("state", state);
        param.put("token", accessToken);
        Result<Void> result = HttpUtils.getHttp(serverUrl + QrLoginConstant.AOTOLOGIN_URL, param, headerMap, Void.class);
        return result;
    }

    public static Result<String> getQrStatus(String serverUrl,String key,  Map<String, String> headerMap) {
        Map<String, String> param = new HashMap<>();
        param.put("key", key);
        Result<String> result = HttpUtils.getHttp(serverUrl + QrLoginConstant.GET_QrStatus_URL, param, headerMap, String.class);
        return result;
    }

    public static Result<RpcAccessToken> refreshQrLogin(String serverUrl, String accessToken, String appId, Map<String, String> headerMap) {
        Map<String, String> param = new HashMap<>();
        param.put("appId", appId);
        param.put("refreshToken", accessToken);
        Result<RpcAccessToken> result = HttpUtils.getHttp(serverUrl + QrLoginConstant.REFRESHLOGIN_URL, param, headerMap, RpcAccessToken.class);
        return result;
    }
}
