/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class PermitResource {
    public List<String> getPermitList() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources("classpath*:auth.yml");
        String key = "auth.exclude_urls";
        return this.getPropertiesList(key, resources);
    }

    private List<String> getPropertiesList(String key, Resource ... resources) {
        ArrayList<String> list = new ArrayList<String>();
        for (Resource resource : resources) {
            Properties properties = this.loadYamlProperties(resource);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String tmpKey = StringUtils.substringBefore((String)entry.getKey().toString(), (String)"[");
                if (!tmpKey.equalsIgnoreCase(key)) continue;
                list.add(entry.getValue().toString());
            }
        }
        return list;
    }

    private Properties loadYamlProperties(Resource ... resources) {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(resources);
        factory.afterPropertiesSet();
        return factory.getObject();
    }
}

