/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.FIFOCache;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.session.SessionAccessToken;
import com.geoway.sso.client.util.StringUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.ServletRequestHandledEvent;

@Component
public class SessionUtils
implements ApplicationListener<ServletRequestHandledEvent> {
    private static FIFOCache<String, String> fifoCache;
    private static ThreadLocal<SessionAccessToken> localAccessSession;

    @Autowired
    public SessionUtils() {
        fifoCache = CacheUtil.newFIFOCache((int)10000000, (long)14400000L);
    }

    public static SessionAccessToken getAccessToken(HttpServletRequest request, String access_token) {
        if (localAccessSession.get() != null) {
            return localAccessSession.get();
        }
        String atcStr = (String)fifoCache.get((Object)("_sessionAccessToken_" + access_token));
        if (StringUtils.isEmpty(atcStr)) {
            return null;
        }
        SessionAccessToken sessionAccessToken = (SessionAccessToken)JSONObject.parseObject((String)atcStr, SessionAccessToken.class);
        localAccessSession.set(sessionAccessToken);
        return sessionAccessToken;
    }

    public static SessionAccessToken getAccessTokenByUserId(HttpServletRequest request, String userId) {
        if (localAccessSession.get() != null) {
            return localAccessSession.get();
        }
        String atcStr = (String)fifoCache.get((Object)("_sessionAccessUserId_" + userId));
        if (StringUtils.isEmpty(atcStr)) {
            return null;
        }
        SessionAccessToken sessionAccessToken = (SessionAccessToken)JSONObject.parseObject((String)atcStr, SessionAccessToken.class);
        localAccessSession.set(sessionAccessToken);
        return sessionAccessToken;
    }

    public static SsoUser getUser(HttpServletRequest request, String access_token) {
        SessionAccessToken sessionAccessToken = SessionUtils.getAccessToken(request, access_token);
        if (ObjectUtil.isNotNull((Object)sessionAccessToken)) {
            return sessionAccessToken.getUser();
        }
        return null;
    }

    public static void setAccessToken(HttpServletRequest request, RpcAccessToken rpcAccessToken) {
        SessionAccessToken sessionAccessToken = null;
        if (rpcAccessToken != null) {
            sessionAccessToken = SessionUtils.createSessionAccessToken(rpcAccessToken);
        }
        localAccessSession.set(sessionAccessToken);
        if (sessionAccessToken != null) {
            fifoCache.put((Object)("_sessionAccessToken_" + sessionAccessToken.getAccessToken()), (Object)JSONObject.toJSONString((Object)sessionAccessToken), (long)(rpcAccessToken.getExpiresIn() * 1000 * 2));
            fifoCache.put((Object)("_sessionAccessUserId_" + sessionAccessToken.getUser().getId()), (Object)JSONObject.toJSONString((Object)sessionAccessToken), (long)(rpcAccessToken.getExpiresIn() * 1000 * 2));
        }
    }

    private static SessionAccessToken createSessionAccessToken(RpcAccessToken accessToken) {
        long expirationTime = System.currentTimeMillis() + (long)(accessToken.getExpiresIn() / 2 * 1000);
        return new SessionAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn(), accessToken.getRefreshToken(), accessToken.getUser(), expirationTime);
    }

    public static void invalidate(HttpServletRequest request, String access_token) {
        fifoCache.remove((Object)("_sessionAccessToken_" + access_token));
        request.getSession().invalidate();
    }

    public static void invalidate(HttpServletRequest request) {
        request.getSession().invalidate();
    }

    public void onApplicationEvent(ServletRequestHandledEvent event) {
        localAccessSession.set(null);
    }

    static {
        localAccessSession = new ThreadLocal();
    }
}

