package com.geoway.sso.client.client.impl;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.sso.client.client.SsoClient;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.CookieUtils;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.client.util.Oauth2Utils;
import org.springframework.stereotype.Component;

import static com.geoway.sso.client.constant.SsoConstant.COOKIE_ACCESS_TOKEN2;

/**
 * 封装登入接口
 */
@Component
public class SsoClientImpl extends Client implements SsoClient {
    /**
     * 账号密码登入
     *
     * @param username
     * @param password
     * @return
     */
    @Override
    public RpcAccessToken getAccessToken(String username, String password) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessToken(provider.getRpcClientInfo().getServerUrl(), provider.getRpcClientInfo().getAppId(), provider.getRpcClientInfo().getAppSecret(), username, password);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public RpcAccessToken getAccessToken(String username, String password, String uuid, String code) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessToken(provider.getRpcClientInfo().getServerUrl(), provider.getRpcClientInfo().getAppId(), provider.getRpcClientInfo().getAppSecret(), username, password);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     * 授权码登入
     *
     * @param code
     * @return
     */
    @Override
    public RpcAccessToken getAccessToken(String code) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessToken(provider.getRpcClientInfo().getServerUrl(), provider.getRpcClientInfo().getAppId(), provider.getRpcClientInfo().getAppSecret(), code);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     * 短信验证码登入
     *
     * @param tel
     * @param uuid
     * @param code
     * @return
     */
    @Override
    public RpcAccessToken getAccessTokenBySms(String tel, String uuid, String code) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessTokenBySms(provider.getRpcClientInfo().getServerUrl(), provider.getRpcClientInfo().getAppId(), provider.getRpcClientInfo().getAppSecret(), tel, uuid, code);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     * 手机一键登入
     *
     * @param processId
     * @param token
     * @param authCode
     * @return
     */
    @Override
    public RpcAccessToken getAccessTokenByOne(String processId, String token, String authCode) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessTokenByOne(provider.getRpcClientInfo().getServerUrl(), provider.getRpcClientInfo().getAppId(), provider.getRpcClientInfo().getAppSecret(), processId, token, authCode);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     * Ca证书登入
     *
     * @param caUserCert
     * @param caOauthName
     * @param
     * @return
     */
    @Override
    public RpcAccessToken getAccessTokenByCa(String caUserCert, String caOauthName) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessTokenByCa(provider.getRpcClientInfo().getServerUrl(), provider.getRpcClientInfo().getAppId(), provider.getRpcClientInfo().getAppSecret(), caUserCert, caOauthName);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }


    /**
     * 刷新访问令牌
     *
     * @param refreshToken 刷新新令牌
     * @return
     */
    @Override
    public RpcAccessToken refreshToken(String refreshToken) {
        Result<RpcAccessToken> result = Oauth2Utils.refreshToken(provider.getRpcClientInfo().getServerUrl(), provider.getRpcClientInfo().getAppId(), refreshToken);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     * 查询令牌对应的用户登录信息
     *
     * @param accessToken 当前用户访问令牌
     * @return
     */
    @Override
    public RpcAccessToken queryAccessToken(String accessToken) {
        if (ObjectUtil.isEmpty(accessToken)) {
            if (HttpServletUtil.getRequest() != null) {
                accessToken = CookieUtils.getCookie(HttpServletUtil.getRequest(), COOKIE_ACCESS_TOKEN2);
            }
        }
        Result<RpcAccessToken> result = Oauth2Utils.queryAccessToken(provider.getRpcClientInfo().getServerUrl(), accessToken);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     * 撤销访问凭证(单点退出)
     *
     * @param accessToken 当前用户令牌
     * @return
     */
    @Override
    public RpcAccessToken revokeAccessToken(String accessToken) {
        Result<RpcAccessToken> result = Oauth2Utils.revokeAccessToken(provider.getRpcClientInfo().getServerUrl(), accessToken);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     * 获取当前用户信息
     *
     * @return
     */
    @Override
    public SsoUser getUserInfo() {
        return CommonLoginUserUtil.getUser();
    }

    @Override
    public String getAccessCode(String accessToken) {
        return getAccessCode(accessToken, 1);
    }

    @Override
    public String getAccessCode(String accessToken, int allowedUseCount) {
        Result<String> result = Oauth2Utils.getAccessCode(provider.getRpcClientInfo().getServerUrl(), provider.getRpcClientInfo().getAppId(), provider.getRpcClientInfo().getAppSecret(), accessToken, allowedUseCount);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        } else {
            throw new RuntimeException(result.getMessage());
        }
    }


}
