/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.filter;

import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.client.filter.LoginFilter;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.session.SessionAccessToken;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.SessionUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RestLoginFilter
extends LoginFilter {
    @Override
    public boolean isAccessAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String code;
        if (request.getMethod().equals("OPTIONS")) {
            response.setStatus(200);
            return true;
        }
        String accessToken = CommonLoginUserUtil.getToken();
        if (accessToken != null) {
            SessionAccessToken sessionAccessToken = SessionUtils.getAccessToken(request, accessToken);
            if (sessionAccessToken != null && (!sessionAccessToken.isExpired() || this.refreshToken(sessionAccessToken.getRefreshToken(), request))) {
                return true;
            }
            Result<RpcAccessToken> queryResult = this.queryAccessToken(accessToken, request);
            if (queryResult == null) {
                this.redirectAjaxLogin(request, response, "\u767b\u5f55\u6388\u6743\u5931\u8d25!");
            } else {
                if (queryResult.isSuccess()) {
                    this.setAccessTokenInSession(queryResult.getData(), request);
                    return true;
                }
                this.redirectAjaxLogin(request, response, queryResult.getMessage());
            }
        }
        if ((code = request.getParameter("code")) != null && code.length() > 5) {
            this.getAccessToken(code, request);
            this.redirectLocalRemoveCode(request, response);
        } else {
            this.redirectAjaxLogin(request, response, "\u767b\u9646\u5931\u8d25\uff01");
        }
        return false;
    }

    private void redirectAjaxLogin(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
        JSONObject resultObject = new JSONObject();
        String loginUrl = this.getServerUrl() + "/login" + "?" + "appId" + "=" + this.getAppId() + "&" + "redirectUri" + "=" + request.getRequestURL() + "&" + "indexUrl" + "=";
        resultObject.put("loginUrl", (Object)loginUrl);
        Result<JSONObject> result = Result.createLoginRedirect(resultObject, msg);
        this.responseJson(response, result);
    }

    @Override
    protected boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("X-Requested-With");
        return requestedWith != null ? "XMLHttpRequest".equals(requestedWith) : false;
    }
}

