package com.geoway.sso.client.rpc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description: RpcSysSystemConsult
 * @author: Liao.yx
 * @date: 2025/11/9
 * @copyRight: 2025 吉威空间信息股份有限公司 All rights reserved.
 */
@Data
public class RpcSysSystemConsult implements Serializable {


    /**
     * 系统名称
     */
    @ApiModelProperty("系统名称")
    private String systemname;

    /**
     * 人名
     */
    @ApiModelProperty("人名")
    private String name;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String companyName;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话", required = true)
    private String tel;

    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String email;

    /**
     * 咨询内容
     */
    @ApiModelProperty(value = "咨询内容",required = true)
    private String desc;
}
