/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.client.impl;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.sso.client.client.SsoClient;
import com.geoway.sso.client.client.impl.Client;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.CookieUtils;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.client.util.Oauth2Utils;
import org.springframework.stereotype.Component;

@Component
public class SsoClientImpl
extends Client
implements SsoClient {
    @Override
    public RpcAccessToken getAccessToken(String username, String password) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessToken(this.provider.getRpcClientInfo().getServerUrl(), this.provider.getRpcClientInfo().getAppId(), this.provider.getRpcClientInfo().getAppSecret(), username, password);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public RpcAccessToken getAccessToken(String username, String password, String uuid, String code) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessToken(this.provider.getRpcClientInfo().getServerUrl(), this.provider.getRpcClientInfo().getAppId(), this.provider.getRpcClientInfo().getAppSecret(), username, password);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public RpcAccessToken getAccessToken(String code) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessToken(this.provider.getRpcClientInfo().getServerUrl(), this.provider.getRpcClientInfo().getAppId(), this.provider.getRpcClientInfo().getAppSecret(), code);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public RpcAccessToken getAccessTokenBySms(String tel, String uuid, String code) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessTokenBySms(this.provider.getRpcClientInfo().getServerUrl(), this.provider.getRpcClientInfo().getAppId(), this.provider.getRpcClientInfo().getAppSecret(), tel, uuid, code);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public RpcAccessToken getAccessTokenByOne(String processId, String token, String authCode) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessTokenByOne(this.provider.getRpcClientInfo().getServerUrl(), this.provider.getRpcClientInfo().getAppId(), this.provider.getRpcClientInfo().getAppSecret(), processId, token, authCode);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public RpcAccessToken getAccessTokenByCa(String caUserCert, String caOauthName) {
        Result<RpcAccessToken> result = Oauth2Utils.getAccessTokenByCa(this.provider.getRpcClientInfo().getServerUrl(), this.provider.getRpcClientInfo().getAppId(), this.provider.getRpcClientInfo().getAppSecret(), caUserCert, caOauthName);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public RpcAccessToken refreshToken(String refreshToken) {
        Result<RpcAccessToken> result = Oauth2Utils.refreshToken(this.provider.getRpcClientInfo().getServerUrl(), this.provider.getRpcClientInfo().getAppId(), refreshToken);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public RpcAccessToken queryAccessToken(String accessToken) {
        Result<RpcAccessToken> result;
        if (ObjectUtil.isEmpty((Object)accessToken) && HttpServletUtil.getRequest() != null) {
            accessToken = CookieUtils.getCookie(HttpServletUtil.getRequest(), "jckj-token");
        }
        if ((result = Oauth2Utils.queryAccessToken(this.provider.getRpcClientInfo().getServerUrl(), accessToken)) == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public RpcAccessToken revokeAccessToken(String accessToken) {
        Result<RpcAccessToken> result = Oauth2Utils.revokeAccessToken(this.provider.getRpcClientInfo().getServerUrl(), accessToken);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public SsoUser getUserInfo() {
        return CommonLoginUserUtil.getUser();
    }

    @Override
    public String getAccessCode(String accessToken) {
        return this.getAccessCode(accessToken, 1);
    }

    @Override
    public String getAccessCode(String accessToken, int allowedUseCount) {
        Result<String> result = Oauth2Utils.getAccessCode(this.provider.getRpcClientInfo().getServerUrl(), this.provider.getRpcClientInfo().getAppId(), this.provider.getRpcClientInfo().getAppSecret(), accessToken, allowedUseCount);
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }
}

