/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.aspect;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.client.impl.OpLogClientImpl;
import com.geoway.sso.client.enums.OpTypeEnum;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import com.geoway.sso.client.rpc.RpcOplog;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.SessionUtils;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Service
@ConditionalOnExpression(value="#{!T(com.geoway.sso.client.constant.SystemConstant).IS_SERVER}")
public class OpLogAspect {
    private static final Logger log = LoggerFactory.getLogger(OpLogAspect.class);
    @Autowired
    RpcClientInfoProvider provider;
    @Autowired
    OpLogClientImpl opLogClient;

    @Pointcut(value="@annotation(com.geoway.sso.client.annotation.OpLog)")
    public void logPointCut() {
    }

    @Before(value="logPointCut()")
    public void beforeExec(JoinPoint joinPoint) {
        block3: {
            block2: {
                OpLog opLog = this.getAnnotationLog(joinPoint);
                if (opLog == null) break block2;
                OpTypeEnum opTypeEnum = opLog.opType();
                opLog.opType();
                if (opTypeEnum.equals((Object)OpTypeEnum.loginout)) break block3;
            }
            return;
        }
        this.doExec(joinPoint, null);
    }

    private void doExec(JoinPoint joinPoint, Object rvt) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            OpLog opLog = this.getAnnotationLog(joinPoint);
            if (opLog == null) {
                return;
            }
            SsoUser sysUser = SessionUtils.getUser(request, null);
            if (sysUser == null) {
                return;
            }
            String methodName = joinPoint.getSignature().getName();
            String typeName = joinPoint.getSignature().getDeclaringTypeName();
            int begin = typeName.lastIndexOf(".") + 1;
            String methodFullName = typeName.substring(begin) + "." + methodName;
            Map map = request.getParameterMap();
            LinkedHashMap<String, String> newParamsMap = new LinkedHashMap<String, String>();
            for (String key : map.keySet()) {
                String newVal = ArrayUtil.join((Object[])((Object[])map.get(key)), (CharSequence)",");
                newParamsMap.put(key, newVal);
            }
            String params = JSON.toJSONString(newParamsMap);
            RpcOplog sysOplog = new RpcOplog();
            sysOplog.setName(opLog.name());
            sysOplog.setDetail(opLog.detail());
            sysOplog.setOptype(opLog.opType().toString());
            sysOplog.setMethod(methodFullName);
            sysOplog.setParam(params);
            sysOplog.setCreatetime(new Date());
            String ip = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
            sysOplog.setMachineName(this.getMachineName(request));
            sysOplog.setIp(ip);
            sysOplog.setSystemid(this.provider.getRpcClientInfo().getSystemId());
            sysOplog.setUserid(sysUser.getId());
            sysOplog.setUsername(sysUser.getUserName());
            sysOplog.setAppid(this.provider.getRpcClientInfo().getAppId());
            this.opLogClient.addOplog(sysOplog);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    @AfterReturning(pointcut="logPointCut()", returning="rvt")
    public void afterExec(JoinPoint joinPoint, Object rvt) {
        block3: {
            block2: {
                OpLog opLog = this.getAnnotationLog(joinPoint);
                if (opLog == null) break block2;
                OpTypeEnum opTypeEnum = opLog.opType();
                opLog.opType();
                if (!opTypeEnum.equals((Object)OpTypeEnum.loginout)) break block3;
            }
            return;
        }
        this.doExec(joinPoint, null);
    }

    private OpLog getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(OpLog.class);
        }
        return null;
    }

    private String getRemoteHost(HttpServletRequest request) {
        String ip = request.getHeader("x-real-ip");
        if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    private String getMachineName(HttpServletRequest request) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (Exception e) {
            return "Administrator";
        }
    }
}

