/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.TenantClient;
import com.geoway.sso.client.client.impl.Client;
import com.geoway.sso.client.client.impl.SsoClientImpl;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcPage;
import com.geoway.sso.client.rpc.RpcSysTenant;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.StringUtils;
import com.geoway.sso.client.util.UisUtils;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TenantClientImpl
extends Client
implements TenantClient {
    @Autowired
    private SsoClientImpl ssoClientImpl;

    @Override
    public boolean isTenantAdmin() {
        SsoUser ssoUser = this.ssoClientImpl.getUserInfo();
        if (ssoUser == null) {
            return false;
        }
        if (!ssoUser.getUserCatalog().equals(2)) {
            return false;
        }
        String currentTenant = this.provider.getRpcClientInfo().getTenantId();
        if (StringUtils.isEmpty(currentTenant)) {
            return false;
        }
        if (StringUtils.isEmpty(ssoUser.getTenantIds())) {
            return false;
        }
        String[] tenants = ssoUser.getTenantIds().split(",");
        return Arrays.stream(tenants).anyMatch(f -> f.equals(currentTenant));
    }

    @Override
    public RpcPage<RpcSysTenant> queryTenantPage(String filterParam, Integer page, Integer size) {
        Result<RpcPage<RpcSysTenant>> result = UisUtils.queryTenantPage(this.provider.getRpcClientInfo().getServerUrl(), filterParam, page, size, this.getHeader());
        if (result == null) {
            return new RpcPage<RpcSysTenant>();
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }
}

