/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcPage;
import com.geoway.sso.client.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static <T> Result<T> getHttp(String url, Map<String, String> paramMap, Map<String, String> headerMap, Class<T> clazz) {
        String jsonStr = HttpUtils.get(url, paramMap, headerMap);
        if (jsonStr == null || jsonStr.isEmpty()) {
            logger.error("url:{} \u5f02\u5e38, return null.", (Object)url);
            return null;
        }
        return (Result)JSONObject.parseObject((String)jsonStr, (TypeReference)new TypeReference<Result<T>>(new Type[]{clazz}){}, (Feature[])new Feature[0]);
    }

    public static <T> Result<List<T>> getHttpList(String url, Map<String, String> paramMap, Map<String, String> headerMap, Class<T> clazz) {
        String jsonStr = HttpUtils.get(url, paramMap, headerMap);
        if (jsonStr == null || jsonStr.isEmpty()) {
            logger.error("url:{} \u5f02\u5e38, return null.", (Object)url);
            return null;
        }
        ParameterizedTypeImpl inner = new ParameterizedTypeImpl(new Type[]{clazz}, null, List.class);
        ParameterizedTypeImpl outer = new ParameterizedTypeImpl(new Type[]{inner}, null, Result.class);
        return (Result)JSONObject.parseObject((String)jsonStr, (Type)outer, (Feature[])new Feature[0]);
    }

    public static <T> Result<RpcPage<T>> getHttpPage(String url, Map<String, String> paramMap, Map<String, String> headerMap, Class<T> clazz) {
        String jsonStr = HttpUtils.get(url, paramMap, headerMap);
        if (jsonStr == null || jsonStr.isEmpty()) {
            logger.error("url:{} \u5f02\u5e38, return null", (Object)url);
            return null;
        }
        ParameterizedTypeImpl inner = new ParameterizedTypeImpl(new Type[]{clazz}, null, RpcPage.class);
        ParameterizedTypeImpl outer = new ParameterizedTypeImpl(new Type[]{inner}, null, Result.class);
        return (Result)JSONObject.parseObject((String)jsonStr, (Type)outer, (Feature[])new Feature[0]);
    }

    public static <T> Result<T> postHttp(String url, Map<String, String> paramMap, Map<String, String> headerMap, Object jsonObject, Class<T> clazz) {
        String jsonStr;
        String jsonObjectStr = "";
        if (jsonObject != null) {
            jsonObjectStr = JSONObject.toJSONString((Object)jsonObject);
        }
        if ((jsonStr = HttpUtils.post(url, paramMap, headerMap, jsonObjectStr)) == null || jsonStr.isEmpty()) {
            logger.error("url:{} \u5f02\u5e38, return null.", (Object)url);
            return null;
        }
        return (Result)JSONObject.parseObject((String)jsonStr, (TypeReference)new TypeReference<Result<T>>(new Type[]{clazz}){}, (Feature[])new Feature[0]);
    }

    public static <T> Result<List<T>> postHttpList(String url, Map<String, String> paramMap, Map<String, String> headerMap, Object jsonObject, Class<T> clazz) {
        String jsonStr;
        String jsonObjectStr = "";
        if (jsonObject != null) {
            jsonObjectStr = JSONObject.toJSONString((Object)jsonObject);
        }
        if ((jsonStr = HttpUtils.post(url, paramMap, headerMap, jsonObjectStr)) == null || jsonStr.isEmpty()) {
            logger.error("url:{} \u5f02\u5e38, return null.", (Object)url);
            return null;
        }
        ParameterizedTypeImpl inner = new ParameterizedTypeImpl(new Type[]{clazz}, null, List.class);
        ParameterizedTypeImpl outer = new ParameterizedTypeImpl(new Type[]{inner}, null, Result.class);
        return (Result)JSONObject.parseObject((String)jsonStr, (Type)outer, (Feature[])new Feature[0]);
    }

    public static <T> Result<RpcPage<T>> postHttpPage(String url, Map<String, String> paramMap, Map<String, String> headerMap, Object jsonObject, Class<T> clazz) {
        String jsonStr;
        String jsonObjectStr = "";
        if (jsonObject != null) {
            jsonObjectStr = JSONObject.toJSONString((Object)jsonObject);
        }
        if ((jsonStr = HttpUtils.post(url, paramMap, headerMap, jsonObjectStr)) == null || jsonStr.isEmpty()) {
            logger.error("url:{} \u5f02\u5e38, return null.", (Object)url);
            return null;
        }
        ParameterizedTypeImpl inner = new ParameterizedTypeImpl(new Type[]{clazz}, null, RpcPage.class);
        ParameterizedTypeImpl outer = new ParameterizedTypeImpl(new Type[]{inner}, null, Result.class);
        return (Result)JSONObject.parseObject((String)jsonStr, (Type)outer, (Feature[])new Feature[0]);
    }

    public static String get(String url, Map<String, String> paramMap, Map<String, String> headerMap) {
        String result = null;
        CloseableHttpResponse response = null;
        String realUrl = url;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            if (paramMap != null && !paramMap.isEmpty()) {
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                    params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                String paramStr = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                realUrl = realUrl + "?" + (String)paramStr;
            }
            HttpGet httpGet = new HttpGet(realUrl);
            if (headerMap != null && !headerMap.isEmpty()) {
                for (Map.Entry<String, String> headerItem : headerMap.entrySet()) {
                    httpGet.setHeader(headerItem.getKey(), headerItem.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)httpGet)) != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity);
                }
                logger.info("url: {}, result: {}", (Object)url, (Object)result);
            }
            Iterator<Map.Entry<String, String>> iterator = result;
            return iterator;
        }
        catch (Exception e) {
            logger.error("url: {}, result: {}", new Object[]{url, result, e});
            throw new RuntimeException(e);
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static String get(String url, Map<String, String> paramMap) {
        return HttpUtils.get(url, paramMap, null);
    }

    public static String get(String url) {
        return HttpUtils.get(url, null);
    }

    public static String post(String url, Map<String, String> paramMap, Map<String, String> headerMap) {
        return HttpUtils.post(url, paramMap, headerMap, null);
    }

    public static String post(String url, Map<String, String> paramMap, Map<String, String> headerMap, String jsonStr) {
        HttpPost httpPost = null;
        CloseableHttpClient httpClient = null;
        try {
            CloseableHttpResponse response;
            HttpEntity entity;
            httpPost = new HttpPost(url);
            if (paramMap != null && !paramMap.isEmpty()) {
                ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                    formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, "UTF-8"));
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(50000).setConnectTimeout(50000).build();
            httpPost.setConfig(requestConfig);
            if (headerMap != null && !headerMap.isEmpty()) {
                for (Map.Entry<String, String> headerItem : headerMap.entrySet()) {
                    httpPost.setHeader(headerItem.getKey(), headerItem.getValue());
                }
            }
            if (StringUtils.isNotEmpty(jsonStr)) {
                StringEntity stringEntity = new StringEntity(jsonStr, ContentType.APPLICATION_JSON);
                httpPost.setEntity((HttpEntity)stringEntity);
            }
            if ((entity = (response = (httpClient = HttpClients.custom().disableAutomaticRetries().build()).execute((HttpUriRequest)httpPost)).getEntity()) != null && response.getStatusLine().getStatusCode() == 200) {
                String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
                logger.info("url: {}, result: {}", (Object)url, (Object)result);
                String string = result;
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            logger.error("url: {}, paramMap: {}", new Object[]{url, paramMap, e});
            throw new RuntimeException(e);
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    public static String post(String url, Map<String, String> paramMap) {
        return HttpUtils.post(url, paramMap, null);
    }

    public static String postHeader(String url, Map<String, String> headerMap) {
        return HttpUtils.post(url, null, headerMap);
    }
}

