package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.TenantClient;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcPage;
import com.geoway.sso.client.rpc.RpcSysTenant;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.Oauth2Utils;
import com.geoway.sso.client.util.StringUtils;
import com.geoway.sso.client.util.UisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;

/**
 * @author 连世忠
 * @ClassName TenantClient
 * @Description TODO
 * @date 2025/3/26 15:39
 * @Version 1.0
 */
@Component
public class TenantClientImpl extends Client implements TenantClient {
    @Autowired
    private SsoClientImpl ssoClientImpl;
    /**
     * 是否是当前租户的租户管理员
     * @return
     */
    @Override
    public boolean isTenantAdmin(){
        SsoUser ssoUser= ssoClientImpl.getUserInfo();
        if(ssoUser==null){
            return false;
        }
        if(!ssoUser.getUserCatalog().equals(2)){
            return false;
        }
        String currentTenant=provider.getRpcClientInfo().getTenantId();
        if(StringUtils.isEmpty(currentTenant)){
            return false;
        }
        if(StringUtils.isEmpty(ssoUser.getTenantIds())){
            return false;
        }
        String[] tenants=ssoUser.getTenantIds().split(",");
        return Arrays.stream(tenants).anyMatch(f->f.equals(currentTenant));
    }

    @Override
    public RpcPage<RpcSysTenant> queryTenantPage(String filterParam, Integer page, Integer size) {
        Result<RpcPage<RpcSysTenant>> result= UisUtils.queryTenantPage(provider.getRpcClientInfo().getServerUrl(),filterParam,page,size,getHeader());
        if(result==null){
            return new RpcPage();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }
}
