package com.geoway.sso.client.enums;

/**
 * @author ALMJ
 * @desc Oauth2授权方式
 */
public enum GrantTypeEnum {
    /**
     * 授权码模式
     */
    AUTHORIZATION_CODE("authorization_code"),
    /**
     * 授权码模式_多次调用
     */
    AUTHORIZATION_CODE_MORE("authorization_code_more"),

    /**
     * 密码模式--无验证码模式
     */
    PASSWORD("password"),
    /**
     * 密码、验证码模式
     */
    PASSWORD_CAPTCHA("password_catpcha"),
    /**
     * 手机号、验证码模式;
     */
    TEL_CAPTCHA("tel_catpcha"),
    /**
     * 手机号、验证码模式;
     */
    CA("ca"),
    /**
     * 手机号、验证码模式;
     */
    ONE("one");

    private String value;

    GrantTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}