package com.geoway.sso.client.client;

import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.RpcQrLoginDTO;
import com.geoway.sso.client.rpc.SsoUser;

/**
 * @author 连世忠
 * @ClassName QrLoginClient
 * @Description TODO
 * @date 2025/7/24 8:24
 * @Version 1.0
 */
public interface QrLoginClient {
    /**
     * 生成登录验证码
     *
     * @return
     */
    RpcQrLoginDTO generateQrCode();

    /**
     * 查询手机二维码登录的access_token 并获取用户详情信息
     * @return
     * @throws Exception
     */
    SsoUser getLoginInfo(String key);

    /**
     * 登入
     * @param accessToken
     * @param key
     * @return
     */
    Boolean autoLogin(String accessToken, String key,String state);

    /**
     * 获取状态
     * @param key
     * @return
     */
    String getQrStatus(String key);

    RpcAccessToken refreshQrLogin(String token);
}
