package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import com.geoway.sso.client.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 连世忠
 * @ClassName Client
 * @Description TODO
 * @date 2025/3/26 11:29
 * @Version 1.0
 */
public abstract  class Client {
    @Autowired
    protected RpcClientInfoProvider provider;
    protected Map<String,String> getHeader(){

        Map<String,String> header=new HashMap<>();
        if(StringUtils.isNotEmpty(provider.getRpcClientInfo().getToken())){
            header.put(SsoConstant.HEADER_ACCESS_TOKEN,provider.getRpcClientInfo().getToken());
        }
        if(StringUtils.isNotEmpty(provider.getRpcClientInfo().getTenantId())){
            header.put(SsoConstant.HEADER_ACCESS_TENANT_ID,provider.getRpcClientInfo().getTenantId());
        }
        if(StringUtils.isNotEmpty(provider.getRpcClientInfo().getTenantId())){
            header.put(SsoConstant.HEADER_ACCESS_TENANT_ID,provider.getRpcClientInfo().getTenantId());
        }
        if(StringUtils.isNotEmpty(provider.getRpcClientInfo().getTenantKey())){
            header.put(SsoConstant.HEADER_ACCESS_TENANT_KEY,provider.getRpcClientInfo().getTenantKey());
        }
        return header;
    }
}
