package com.geoway.sso.client.client.impl;

import com.geoway.sso.client.client.RoleClient;
import com.geoway.sso.client.client.impl.Client;
import com.geoway.sso.client.rpc.RpcPage;
import com.geoway.sso.client.rpc.RpcSysRole;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.util.UisUtils;
import com.geoway.sso.client.rpc.Result;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName UserClient
 * @Description TODO
 * @date 2025/3/26 11:32
 * @Version 1.0
 */
@Component
public class RoleClientImpl extends Client implements RoleClient {
    /**
     * 获取角色树列表
     * @param filterParam
     * @return
     */
    @Override
    public List<RpcSysRole> queryRoleTree(String filterParam) {
        Result<List<RpcSysRole>> result= UisUtils.queryRoleTree(provider.getRpcClientInfo().getServerUrl(),filterParam,getHeader());
        if(result==null){
            return new ArrayList<>();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }


    /**
     * 获取角色列表
     * @param filterParam
     * @return
     */
    @Override
    public List<RpcSysRole> queryRoleList( String filterParam) {
        Result<List<RpcSysRole>> result= UisUtils.queryRoleList(provider.getRpcClientInfo().getServerUrl(),filterParam,getHeader());
        if(result==null){
            return new ArrayList<>();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    /**
     * 获取角色关联用户
     * @param roleId
     * @return
     */
    @Override
    public List<RpcSysUser> queryRoleUsers(String roleId) {
        Result<List<RpcSysUser>> result= UisUtils.queryRoleUsers(provider.getRpcClientInfo().getServerUrl(),roleId,getHeader());
        if(result==null){
            return new ArrayList<>();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }

    @Override
    public RpcPage<RpcSysRole> queryRolePage(String filterParam, Integer page, Integer size) {
        Result<RpcPage<RpcSysRole>> result= UisUtils.queryRolePage(provider.getRpcClientInfo().getServerUrl(),filterParam,page,size,getHeader());
        if(result==null){
            return new RpcPage();
        }
        if(result.isSuccess()){
            return result.getData();
        }else{
            throw new RuntimeException(result.getMessage());
        }
    }
}
