package com.geoway.sso.client.client;

import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysSystemConsult;
import com.geoway.sso.client.rpc.RpcSysTenant;
import com.geoway.sso.client.rpc.RpcSystemInfoDTO;

import java.util.List;

/**
 * @author 连世忠
 * @ClassName SystemClient
 * @Description TODO
 * @date 2025/7/16 8:53
 * @Version 1.0
 */
public interface SystemClient {
    /**
     * 查询系统详情，包含系统基本信息，系统菜单信息，系统主题，系统个人菜单信息
     *
     * @param systemKey
     * @return
     */
    RpcSystemInfoDTO querySystemInfoByKey(String systemKey);

    /**
     * 租户信息
     *
     * @param systemId
     * @return
     */
    List<RpcSysTenant> queryTenants(String systemId);

    /**
     * 保存产品咨询信息
     *
     * @param consult
     */
    Result<Void> saveSystemConsult(RpcSysSystemConsult consult);
}
